
# Table of Contents

1.  [Purpose](#org97043bf)
2.  [Installation](#org95884b1)
3.  [Request for help](#orgc61f277)
4.  [License](#orgca3f794)



<a id="org97043bf"></a>

# Purpose

The purpose of the `makegobbler` package is to make easy to gobble (drop) or ungobble
(keep) some part of your LaTeX source code, conditionally or unconditionally. The part
that is to be gobbled/ungobbled is delimited with a user-defined delimiter control
sequence.


<a id="org95884b1"></a>

# Installation

One can use the following bash script with the current directory containing the archive
`makegobbler.zip`.

    # make a temp dir for easier cleanup
    work_dir=$(mktemp -d /tmp/makegobbler-install.XXXXXX)
    cp makegobbler.zip $work_dir
    pushd $work_dir
    # unzip
    unzip makegobbler.zip
    cd makegobbler
    # set TEXMF_INSTALL_DIR to the installation target TEXMF
    [ -d "$TEXMF_INSTALL_DIR" ] || TEXMF_INSTALL_DIR=$(HOME)/texmf
    pdftex makegobbler.ins
    mkdir -p "$TEXMF_INSTALL_DIR/tex/latex/makegobbler"
    cp makegobbler.sty "$TEXMF_INSTALL_DIR/tex/latex/makegobbler"
    # doc generation, skip if you don't want to recompile the manual
    latexmk -pdf makegobbler.dtx
    mkdir -p "$TEXMF_INSTALL_DIR/doc/latex/makegobbler"
    cp makegobbler.pdf "$TEXMF_INSTALL_DIR/doc/latex/makegobbler/makegobbler-doc.pdf"
    # cleanup
    popd
    rm -fr $work_dir


<a id="orgc61f277"></a>

# Request for help

Any volunteer to translate the manual to your favorite language is welcome.


<a id="orgca3f794"></a>

# License

Le package is dual licensed.

-   [LPPL 1.3c license](https://ctan.org/license/lppl1.3c)
-   [CeCILL v2 license](https://cecill.info/licences/Licence_CeCILL_V2-fr.html)

