## LibraryNames.cmake
##
## Copyright (C) 2006-2025 Christian Schenk
## 
## This file is free software; the copyright holder gives
## unlimited permission to copy and/or distribute it, with or
## without modifications, as long as this notice is preserved.

## shared library names; naming convention (Windows):
##    MiKTeXNNNNNN-NAME[-REL]
## where:
##    NAME is the component name
##    NNNNNN is the MiKTeX major.minor.patch version (as an integer)
##    REL is the DLL release state
##
## shared library names; naming convention (other):
##    miktex-NAME
## where:
##    NAME is the component name
if(MIKTEX_NATIVE_WINDOWS)
    if(MIKTEX_RELEASE_STATE EQUAL 0)
        set(miktex_dll_prefix MiKTeX${MIKTEX_MAJOR_MINOR_PATCH_INT})
    elseif(MIKTEX_RELEASE_STATE EQUAL 1)
        set(miktex_dll_prefix MiKTeX${MIKTEX_MAJOR_MINOR_PATCH_INT}-next)
    elseif(MIKTEX_RELEASE_STATE EQUAL 4)
        set(miktex_dll_prefix MiKTeX${MIKTEX_MAJOR_MINOR_PATCH_INT}-debug)
    endif()
else()
    set(miktex_dll_prefix miktex)
endif()

macro(define_library _name)
    set(_lib_name ${_name})
    if(${ARGC} GREATER 1)
        set(_var_name_prefix ${ARGV1})
    else()
        set(_var_name_prefix ${_lib_name})
    endif()
    set(${_var_name_prefix}_dll_name "${miktex_dll_prefix}-${_lib_name}")
    set(${_var_name_prefix}_lib_name "${_lib_name}-static")
endmacro()

define_library(app)
define_library(apr)
define_library(aprutil apr_util)
define_library(archive)
define_library(bzip2)
define_library(cairo)
define_library(config)
define_library(core)
define_library(curl)
define_library(dib)
define_library(dvi)
define_library(egl_registry)
define_library(expat)
define_library(fmt)
define_library(fontconfig)
define_library(freeglut)
define_library(freetype2)
define_library(fribidi)
define_library(gd)
define_library(getopt)
define_library(glm)
define_library(gmp)
define_library(graphite2)
define_library(harfbuzz)
define_library(hunspell)
define_library(jpeg)
define_library(kpathsea kpsemu)
define_library("libressl-crypto" libressl_crypto)
define_library("libressl-ssl" libressl_ssl)
define_library(loc)
define_library(log4cxx)
define_library(lua53)
define_library(luajit)
define_library(lzma2 lzma)
define_library(md5)
define_library(metapost)
define_library("metapost-backends" metapost_backends)
define_library("metapost-core" metapost_core)
define_library("metapost-extramath" metapost_extramath)
define_library("metapost-util" metapost_util)
define_library(mpfi)
define_library(mpfr)
define_library(mspack)
define_library(nlohmann_json)
define_library(opengl_registry)
define_library(packagemanager mpm)
define_library(pbm)
define_library(pgm)
define_library(pixman)
define_library(png)
define_library(pnm)
define_library(poppler)
define_library("poppler-Qt" poppler_qt)
define_library(popt)
define_library(pplib)
define_library(ppm)
define_library(psres)
define_library(ptexenc)
define_library(regex)
define_library(res)
define_library(setup)
define_library(teckit)
define_library(tex)
define_library(texmf)
define_library(trace)
define_library("ui-Qt" ui_qt)
define_library(unxemu)
define_library(uriparser)
define_library(utf8wrap)
define_library(util)
define_library(web2c w2cemu)
define_library(web2c_sources)
define_library(xpdf)
define_library(zlib)
define_library(zzip)

if(MIKTEX_NATIVE_WINDOWS)
    set(core_ps_dll_name  "${core_dll_name}-PS")
    set(mpm_ps_dll_name   "${mpm_dll_name}-PS")
    set(mpm_tlb_name      "${miktex_dll_prefix}-packageManager")
    set(session_tlb_name  "${miktex_dll_prefix}-session")
endif()
