## This -*- perl -*- script writes the Makefile for Tie::File
# You should read "perldoc perlmodinstall" for instructions on
#  how to install modules like this.

require 5.006; # module uses 'our'
use strict;
use ExtUtils::MakeMaker;
WriteMakefile(
    'NAME' => 'Tie::File',
    'VERSION_FROM'    => 'lib/Tie/File.pm',
    'ABSTRACT_FROM'   => 'lib/Tie/File.pm',
    'AUTHOR'          => 'Mark Jason Dominus <MJD@cpan.org>',
    'dist'=> { COMPRESS => 'gzip -6f', SUFFIX => 'gz', },
    INSTALLDIRS => ($] >= 5.007 && $] < 5.012) ? 'perl' : 'site',
    DIR => [],
    META_MERGE  => {
        resources => {
            license     => 'http://dev.perl.org/licenses/',
            bugtracker  => 'https://github.com/Perl/perl5/issues',
            repository  => 'https://github.com/Perl/perl5/tree/blead/dist/Tie-File',
            MailingList => 'http://lists.perl.org/list/perl5-porters.html',
        },
    },
    PREREQ_PM => {
        'constant' => '1.03',
    },
);
# generated by Makepmdist (mkpmdist) v1.01

sub libscan { # Determine what shouldn't get installed
  my($self, $path) = @_;
  return '' if $path =~ m/~/;
  return $path;
}
__END__

