---
title: Design Proposals
---

This section contains design proposals, listed as subpages below.

In each proposal, please add a header and a TOC if it is longer than a page. You can cut&paste the structure in [Proposed Collation Additions](/development/development-process/design-proposals/proposed-collation-additions) and make the necessary changes.

[Alternate Time Formats](/development/development-process/design-proposals/alternate-time-formats)

[BCP 47 Changes (DRAFT)](/development/development-process/design-proposals/bcp-47-changes-draft)

[BCP47 Syntax Mapping](/development/development-process/design-proposals/bcp47-syntax-mapping)

[BCP47 Validation and Canonicalization](/development/development-process/design-proposals/bcp47-validation-and-canonicalization)

[BIDI handling of Structured Text](/development/development-process/design-proposals/bidi-handling-of-structured-text)

[Change to Sites?](/development/development-process/design-proposals/change-to-sites)

[Chinese (and other) calendar support, intercalary months, year cycles](/development/development-process/design-proposals/chinese-and-other-calendar-support-intercalary-months-year-cycles)

[Consistent Casing](/development/development-process/design-proposals/consistent-casing)

[Coverage Revision](/development/development-process/design-proposals/coverage-revision)

[Currency Code Fallback](/development/development-process/design-proposals/currency-code-fallback)

[Day-Period Design](/development/development-process/design-proposals/day-period-design)

[Delimiter (Quotation Mark) Proposal](/development/development-process/design-proposals/delimiter-quotation-mark-proposal)

[English Inheritance](/development/development-process/design-proposals/english-inheritance)

[European Ordering Rules Issues](/development/development-process/design-proposals/european-ordering-rules-issues)

[Extended Windows-Olson zid mapping](/development/development-process/design-proposals/extended-windows-olson-zid-mapping)

[Fractional Plurals](/development/development-process/design-proposals/fractional-plurals)

[Generic calendar data](/development/development-process/design-proposals/generic-calendar-data)

[Grammar & capitalization forms for date/time elements and others](/development/development-process/design-proposals/grammar-capitalization-forms-for-datetime-elements-and-others)

[Grapheme Usage](/development/development-process/design-proposals/grapheme-usage)

[Hebrew Months](/development/development-process/design-proposals/hebrew-months)

[Index Characters](/development/development-process/design-proposals/index-characters)

[Islamic Calendar Types](/development/development-process/design-proposals/islamic-calendar-types)

[ISO 639 Deprecation Requests - DRAFT](/development/development-process/design-proposals/iso-639-deprecation-requests-draft)

[JSON Packaging (Approved by the CLDR TC on 2015-03-25)](/development/development-process/design-proposals/json-packaging-approved-by-the-cldr-tc-on-2015-03-25)

[Language Data Consistency](/development/development-process/design-proposals/language-data-consistency)

[Language Distance Data](/development/development-process/design-proposals/language-distance-data)

[List Formatting](/development/development-process/design-proposals/list-formatting)

[Locale Format](/development/development-process/design-proposals/locale-format)

[Localized GMT Format](/development/development-process/design-proposals/localized-gmt-format)

[Math Formula Preferences](/development/development-process/design-proposals/math-formula-preferences)

[New BCP47 Extension T Fields](/development/development-process/design-proposals/new-bcp47-extension-t-fields)

[New Time Zone Patterns](/development/development-process/design-proposals/new-time-zone-patterns)

[Path Filtering](/development/development-process/design-proposals/path-filtering)

[Pattern character for “related year”](/development/development-process/design-proposals/pattern-character-for-related-year)

[Pinyin Fixes](/development/development-process/design-proposals/pinyin-fixes)

[Post Mortem](/development/development-process/design-proposals/post-mortem)

[Proposed Collation Additions](/development/development-process/design-proposals/proposed-collation-additions)

[Resolution of CLDR files](/development/development-process/design-proposals/resolution-of-cldr-files)

[script-metadata](/development/development-process/design-proposals/script-metadata)

[Search collators](/development/development-process/design-proposals/search-collators)

[Secular/neutral eras](/development/development-process/design-proposals/secularneutral-eras)

[Specifying text break variants in locale IDs](/development/development-process/design-proposals/specifying-text-break-variants-in-locale-ids)

[Suggested Exemplar Revisions](/development/development-process/design-proposals/suggested-exemplar-revisions)

[Supported NumberingSystems](/development/development-process/design-proposals/supported-numberingsystems)

[Thoughts on Survey Tool Backend](/development/development-process/design-proposals/thoughts-on-survey-tool-backend)

[Time Zone Data Reorganization](/development/development-process/design-proposals/time-zone-data-reorganization)

[Transform Fallback](/development/development-process/design-proposals/transform-fallback)

[Transform keywords](/development/development-process/design-proposals/transform-keywords)

[Unihan Data](/development/development-process/design-proposals/unihan-data)

[Units: pixels, ems, display resolution](/development/development-process/design-proposals/units-pixels-ems-display-resolution)

[UTS #35 Splitting](/development/development-process/design-proposals/uts-35-splitting)

[Voting](/development/development-process/design-proposals/voting)

[XMB](/development/development-process/design-proposals/xmb)

