; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -S -mtriple=riscv64 -mattr=+v,+f,+d,+zvfh,+zvfbfmin | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -S -mtriple=riscv64 -mattr=+v,+f,+d,+zvfhmin,+zvfbfmin | FileCheck %s --check-prefixes=CHECK,ZVFHMIN

define void @sqrt() {
; CHECK-LABEL: 'sqrt'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = call bfloat @llvm.sqrt.bf16(bfloat poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = call <2 x bfloat> @llvm.sqrt.v2bf16(<2 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = call <4 x bfloat> @llvm.sqrt.v4bf16(<4 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %4 = call <8 x bfloat> @llvm.sqrt.v8bf16(<8 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %5 = call <16 x bfloat> @llvm.sqrt.v16bf16(<16 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %6 = call <32 x bfloat> @llvm.sqrt.v32bf16(<32 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = call <vscale x 2 x bfloat> @llvm.sqrt.nxv2bf16(<vscale x 2 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %8 = call <vscale x 4 x bfloat> @llvm.sqrt.nxv4bf16(<vscale x 4 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %9 = call <vscale x 8 x bfloat> @llvm.sqrt.nxv8bf16(<vscale x 8 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %10 = call <vscale x 16 x bfloat> @llvm.sqrt.nxv16bf16(<vscale x 16 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %11 = call <vscale x 32 x bfloat> @llvm.sqrt.nxv32bf16(<vscale x 32 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %12 = call float @llvm.sqrt.f32(float poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %13 = call <2 x float> @llvm.sqrt.v2f32(<2 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %14 = call <4 x float> @llvm.sqrt.v4f32(<4 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %15 = call <8 x float> @llvm.sqrt.v8f32(<8 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %16 = call <16 x float> @llvm.sqrt.v16f32(<16 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %17 = call <vscale x 1 x float> @llvm.sqrt.nxv1f32(<vscale x 1 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %18 = call <vscale x 2 x float> @llvm.sqrt.nxv2f32(<vscale x 2 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %19 = call <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %20 = call <vscale x 8 x float> @llvm.sqrt.nxv8f32(<vscale x 8 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %21 = call <vscale x 16 x float> @llvm.sqrt.nxv16f32(<vscale x 16 x float> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %22 = call double @llvm.sqrt.f64(double poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %23 = call <2 x double> @llvm.sqrt.v2f64(<2 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %24 = call <4 x double> @llvm.sqrt.v4f64(<4 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %25 = call <8 x double> @llvm.sqrt.v8f64(<8 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %26 = call <16 x double> @llvm.sqrt.v16f64(<16 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %27 = call <vscale x 1 x double> @llvm.sqrt.nxv1f64(<vscale x 1 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %28 = call <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %29 = call <vscale x 4 x double> @llvm.sqrt.nxv4f64(<vscale x 4 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %30 = call <vscale x 8 x double> @llvm.sqrt.nxv8f64(<vscale x 8 x double> poison)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  call bfloat @llvm.sqrt.bf16(bfloat poison)
  call <2 x bfloat> @llvm.sqrt.v2bf16(<2 x bfloat> poison)
  call <4 x bfloat> @llvm.sqrt.v4bf16(<4 x bfloat> poison)
  call <8 x bfloat> @llvm.sqrt.v8bf16(<8 x bfloat> poison)
  call <16 x bfloat> @llvm.sqrt.v16bf16(<16 x bfloat> poison)
  call <32 x bfloat> @llvm.sqrt.v32bf16(<32 x bfloat> poison)
  call <vscale x 2 x bfloat> @llvm.sqrt.nxv2bf16(<vscale x 2 x bfloat> poison)
  call <vscale x 4 x bfloat> @llvm.sqrt.nxv4bf16(<vscale x 4 x bfloat> poison)
  call <vscale x 8 x bfloat> @llvm.sqrt.nxv8bf16(<vscale x 8 x bfloat> poison)
  call <vscale x 16 x bfloat> @llvm.sqrt.nxv16bf16(<vscale x 16 x bfloat> poison)
  call <vscale x 32 x bfloat> @llvm.sqrt.nxv32bf16(<vscale x 32 x bfloat> poison)
  call float @llvm.sqrt.f32(float poison)
  call <2 x float> @llvm.sqrt.v2f32(<2 x float> poison)
  call <4 x float> @llvm.sqrt.v4f32(<4 x float> poison)
  call <8 x float> @llvm.sqrt.v8f32(<8 x float> poison)
  call <16 x float> @llvm.sqrt.v16f32(<16 x float> poison)
  call <vscale x 1 x float> @llvm.sqrt.nxv1f32(<vscale x 1 x float> poison)
  call <vscale x 2 x float> @llvm.sqrt.nxv2f32(<vscale x 2 x float> poison)
  call <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> poison)
  call <vscale x 8 x float> @llvm.sqrt.nxv8f32(<vscale x 8 x float> poison)
  call <vscale x 16 x float> @llvm.sqrt.nxv16f32(<vscale x 16 x float> poison)
  call double @llvm.sqrt.f64(double poison)
  call <2 x double> @llvm.sqrt.v2f64(<2 x double> poison)
  call <4 x double> @llvm.sqrt.v4f64(<4 x double> poison)
  call <8 x double> @llvm.sqrt.v8f64(<8 x double> poison)
  call <16 x double> @llvm.sqrt.v16f64(<16 x double> poison)
  call <vscale x 1 x double> @llvm.sqrt.nxv1f64(<vscale x 1 x double> poison)
  call <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> poison)
  call <vscale x 4 x double> @llvm.sqrt.nxv4f64(<vscale x 4 x double> poison)
  call <vscale x 8 x double> @llvm.sqrt.nxv8f64(<vscale x 8 x double> poison)
  ret void
}

define void @sqrt_f16() {
; ZVFH-LABEL: 'sqrt_f16'
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = call half @llvm.sqrt.f16(half poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %2 = call <2 x half> @llvm.sqrt.v2f16(<2 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %3 = call <4 x half> @llvm.sqrt.v4f16(<4 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %4 = call <8 x half> @llvm.sqrt.v8f16(<8 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %5 = call <16 x half> @llvm.sqrt.v16f16(<16 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %6 = call <32 x half> @llvm.sqrt.v32f16(<32 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %7 = call <vscale x 2 x half> @llvm.sqrt.nxv2f16(<vscale x 2 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %8 = call <vscale x 4 x half> @llvm.sqrt.nxv4f16(<vscale x 4 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %9 = call <vscale x 8 x half> @llvm.sqrt.nxv8f16(<vscale x 8 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %10 = call <vscale x 16 x half> @llvm.sqrt.nxv16f16(<vscale x 16 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call <vscale x 32 x half> @llvm.sqrt.nxv32f16(<vscale x 32 x half> poison)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; ZVFHMIN-LABEL: 'sqrt_f16'
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = call half @llvm.sqrt.f16(half poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %2 = call <2 x half> @llvm.sqrt.v2f16(<2 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %3 = call <4 x half> @llvm.sqrt.v4f16(<4 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %4 = call <8 x half> @llvm.sqrt.v8f16(<8 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %5 = call <16 x half> @llvm.sqrt.v16f16(<16 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %6 = call <32 x half> @llvm.sqrt.v32f16(<32 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %7 = call <vscale x 2 x half> @llvm.sqrt.nxv2f16(<vscale x 2 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %8 = call <vscale x 4 x half> @llvm.sqrt.nxv4f16(<vscale x 4 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %9 = call <vscale x 8 x half> @llvm.sqrt.nxv8f16(<vscale x 8 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %10 = call <vscale x 16 x half> @llvm.sqrt.nxv16f16(<vscale x 16 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %11 = call <vscale x 32 x half> @llvm.sqrt.nxv32f16(<vscale x 32 x half> poison)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  call half @llvm.sqrt.f16(half poison)
  call <2 x half> @llvm.sqrt.v2f16(<2 x half> poison)
  call <4 x half> @llvm.sqrt.v4f16(<4 x half> poison)
  call <8 x half> @llvm.sqrt.v8f16(<8 x half> poison)
  call <16 x half> @llvm.sqrt.v16f16(<16 x half> poison)
  call <32 x half> @llvm.sqrt.v32f16(<32 x half> poison)
  call <vscale x 2 x half> @llvm.sqrt.nxv2f16(<vscale x 2 x half> poison)
  call <vscale x 4 x half> @llvm.sqrt.nxv4f16(<vscale x 4 x half> poison)
  call <vscale x 8 x half> @llvm.sqrt.nxv8f16(<vscale x 8 x half> poison)
  call <vscale x 16 x half> @llvm.sqrt.nxv16f16(<vscale x 16 x half> poison)
  call <vscale x 32 x half> @llvm.sqrt.nxv32f16(<vscale x 32 x half> poison)
  ret void
}

define void @pow() {
; CHECK-LABEL: 'pow'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call bfloat @llvm.pow.bf16(bfloat undef, bfloat undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %2 = call <2 x bfloat> @llvm.pow.v2bf16(<2 x bfloat> undef, <2 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %3 = call <4 x bfloat> @llvm.pow.v4bf16(<4 x bfloat> undef, <4 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %4 = call <8 x bfloat> @llvm.pow.v8bf16(<8 x bfloat> undef, <8 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x bfloat> @llvm.pow.v16bf16(<16 x bfloat> undef, <16 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x bfloat> @llvm.pow.nxv1bf16(<vscale x 1 x bfloat> undef, <vscale x 1 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x bfloat> @llvm.pow.nxv2bf16(<vscale x 2 x bfloat> undef, <vscale x 2 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x bfloat> @llvm.pow.nxv4bf16(<vscale x 4 x bfloat> undef, <vscale x 4 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x bfloat> @llvm.pow.nxv8bf16(<vscale x 8 x bfloat> undef, <vscale x 8 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x bfloat> @llvm.pow.nxv16bf16(<vscale x 16 x bfloat> undef, <vscale x 16 x bfloat> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call float @llvm.pow.f32(float undef, float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %12 = call <2 x float> @llvm.pow.v2f32(<2 x float> undef, <2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %13 = call <4 x float> @llvm.pow.v4f32(<4 x float> undef, <4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x float> @llvm.pow.v8f32(<8 x float> undef, <8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x float> @llvm.pow.v16f32(<16 x float> undef, <16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x float> @llvm.pow.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x float> @llvm.pow.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x float> @llvm.pow.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x float> @llvm.pow.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %20 = call <vscale x 16 x float> @llvm.pow.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %21 = call double @llvm.pow.f64(double undef, double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %22 = call <2 x double> @llvm.pow.v2f64(<2 x double> undef, <2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %23 = call <4 x double> @llvm.pow.v4f64(<4 x double> undef, <4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %24 = call <8 x double> @llvm.pow.v8f64(<8 x double> undef, <8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %25 = call <16 x double> @llvm.pow.v16f64(<16 x double> undef, <16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %26 = call <vscale x 1 x double> @llvm.pow.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %27 = call <vscale x 2 x double> @llvm.pow.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %28 = call <vscale x 4 x double> @llvm.pow.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %29 = call <vscale x 8 x double> @llvm.pow.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  call bfloat @llvm.pow.bf16(bfloat undef, bfloat undef)
  call <2 x bfloat> @llvm.pow.v2bf16(<2 x bfloat> undef, <2 x bfloat> undef)
  call <4 x bfloat> @llvm.pow.v4bf16(<4 x bfloat> undef, <4 x bfloat> undef)
  call <8 x bfloat> @llvm.pow.v8bf16(<8 x bfloat> undef, <8 x bfloat> undef)
  call <16 x bfloat> @llvm.pow.v16bf16(<16 x bfloat> undef, <16 x bfloat> undef)
  call <vscale x 1 x bfloat> @llvm.pow.nxv1bf16(<vscale x 1 x bfloat> undef, <vscale x 1 x bfloat> undef)
  call <vscale x 2 x bfloat> @llvm.pow.nxv2bf16(<vscale x 2 x bfloat> undef, <vscale x 2 x bfloat> undef)
  call <vscale x 4 x bfloat> @llvm.pow.nxv4bf16(<vscale x 4 x bfloat> undef, <vscale x 4 x bfloat> undef)
  call <vscale x 8 x bfloat> @llvm.pow.nxv8bf16(<vscale x 8 x bfloat> undef, <vscale x 8 x bfloat> undef)
  call <vscale x 16 x bfloat> @llvm.pow.nxv16bf16(<vscale x 16 x bfloat> undef, <vscale x 16 x bfloat> undef)
  call float @llvm.pow.f32(float undef, float undef)
  call <2 x float> @llvm.pow.v2f32(<2 x float> undef, <2 x float> undef)
  call <4 x float> @llvm.pow.v4f32(<4 x float> undef, <4 x float> undef)
  call <8 x float> @llvm.pow.v8f32(<8 x float> undef, <8 x float> undef)
  call <16 x float> @llvm.pow.v16f32(<16 x float> undef, <16 x float> undef)
  call <vscale x 1 x float> @llvm.pow.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.pow.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.pow.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.pow.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.pow.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x float> undef)
  call double @llvm.pow.f64(double undef, double undef)
  call <2 x double> @llvm.pow.v2f64(<2 x double> undef, <2 x double> undef)
  call <4 x double> @llvm.pow.v4f64(<4 x double> undef, <4 x double> undef)
  call <8 x double> @llvm.pow.v8f64(<8 x double> undef, <8 x double> undef)
  call <16 x double> @llvm.pow.v16f64(<16 x double> undef, <16 x double> undef)
  call <vscale x 1 x double> @llvm.pow.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.pow.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.pow.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.pow.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x double> undef)
  ret void
}

define void @pow_f16() {
; ZVFH-LABEL: 'pow_f16'
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %1 = call half @llvm.pow.f16(half undef, half undef)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %2 = call <2 x half> @llvm.pow.v2f16(<2 x half> undef, <2 x half> undef)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %3 = call <4 x half> @llvm.pow.v4f16(<4 x half> undef, <4 x half> undef)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %4 = call <8 x half> @llvm.pow.v8f16(<8 x half> undef, <8 x half> undef)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %5 = call <16 x half> @llvm.pow.v16f16(<16 x half> undef, <16 x half> undef)
; ZVFH-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x half> @llvm.pow.nxv1f16(<vscale x 1 x half> undef, <vscale x 1 x half> undef)
; ZVFH-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x half> @llvm.pow.nxv2f16(<vscale x 2 x half> undef, <vscale x 2 x half> undef)
; ZVFH-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x half> @llvm.pow.nxv4f16(<vscale x 4 x half> undef, <vscale x 4 x half> undef)
; ZVFH-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x half> @llvm.pow.nxv8f16(<vscale x 8 x half> undef, <vscale x 8 x half> undef)
; ZVFH-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x half> @llvm.pow.nxv16f16(<vscale x 16 x half> undef, <vscale x 16 x half> undef)
; ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; ZVFHMIN-LABEL: 'pow_f16'
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call half @llvm.pow.f16(half undef, half undef)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %2 = call <2 x half> @llvm.pow.v2f16(<2 x half> undef, <2 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %3 = call <4 x half> @llvm.pow.v4f16(<4 x half> undef, <4 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %4 = call <8 x half> @llvm.pow.v8f16(<8 x half> undef, <8 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x half> @llvm.pow.v16f16(<16 x half> undef, <16 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x half> @llvm.pow.nxv1f16(<vscale x 1 x half> undef, <vscale x 1 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x half> @llvm.pow.nxv2f16(<vscale x 2 x half> undef, <vscale x 2 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x half> @llvm.pow.nxv4f16(<vscale x 4 x half> undef, <vscale x 4 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x half> @llvm.pow.nxv8f16(<vscale x 8 x half> undef, <vscale x 8 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x half> @llvm.pow.nxv16f16(<vscale x 16 x half> undef, <vscale x 16 x half> undef)
; ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  call half @llvm.pow.f16(half undef, half undef)
  call <2 x half> @llvm.pow.v2f16(<2 x half> undef, <2 x half> undef)
  call <4 x half> @llvm.pow.v4f16(<4 x half> undef, <4 x half> undef)
  call <8 x half> @llvm.pow.v8f16(<8 x half> undef, <8 x half> undef)
  call <16 x half> @llvm.pow.v16f16(<16 x half> undef, <16 x half> undef)
  call <vscale x 1 x half> @llvm.pow.nxv1f16(<vscale x 1 x half> undef, <vscale x 1 x half> undef)
  call <vscale x 2 x half> @llvm.pow.nxv2f16(<vscale x 2 x half> undef, <vscale x 2 x half> undef)
  call <vscale x 4 x half> @llvm.pow.nxv4f16(<vscale x 4 x half> undef, <vscale x 4 x half> undef)
  call <vscale x 8 x half> @llvm.pow.nxv8f16(<vscale x 8 x half> undef, <vscale x 8 x half> undef)
  call <vscale x 16 x half> @llvm.pow.nxv16f16(<vscale x 16 x half> undef, <vscale x 16 x half> undef)
  ret void
}
