; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S -data-layout="E" | FileCheck %s --check-prefixes=ALL
; RUN: opt < %s -passes=instcombine -S -data-layout="e" | FileCheck %s --check-prefixes=ALL

declare void @use(i8)
declare void @use64(i64)

define <4 x i16> @low_index_same_length_poison_basevec(i64 %x) {
; ALL-LABEL: @low_index_same_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 0
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 0
  ret <4 x i16> %r
}

define <4 x i16> @high_index_same_length_poison_basevec(i64 %x) {
; ALL-LABEL: @high_index_same_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 3
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 3
  ret <4 x i16> %r
}

define <4 x i16> @wrong_index_same_length_poison_basevec(i64 %x) {
; ALL-LABEL: @wrong_index_same_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 1
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 1
  ret <4 x i16> %r
}

define <8 x i16> @low_index_longer_length_poison_basevec(i64 %x) {
; ALL-LABEL: @low_index_longer_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> poison, i16 [[T]], i64 0
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <8 x i16> poison, i16 %t, i64 0
  ret <8 x i16> %r
}

define <8 x i16> @high_index_longer_length_poison_basevec(i64 %x) {
; ALL-LABEL: @high_index_longer_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> poison, i16 [[T]], i64 3
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <8 x i16> poison, i16 %t, i64 3
  ret <8 x i16> %r
}

define <8 x i16> @wrong_index_longer_length_poison_basevec(i64 %x) {
; ALL-LABEL: @wrong_index_longer_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> poison, i16 [[T]], i64 7
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <8 x i16> poison, i16 %t, i64 7
  ret <8 x i16> %r
}

define <2 x i16> @low_index_shorter_length_poison_basevec(i64 %x) {
; ALL-LABEL: @low_index_shorter_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <2 x i16> poison, i16 [[T]], i64 0
; ALL-NEXT:    ret <2 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <2 x i16> poison, i16 %t, i64 0
  ret <2 x i16> %r
}

define <4 x i8> @wrong_index_shorter_length_poison_basevec(i64 %x) {
; ALL-LABEL: @wrong_index_shorter_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 3
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %t = trunc i64 %x to i8
  %r = insertelement <4 x i8> poison, i8 %t, i64 3
  ret <4 x i8> %r
}

define <4 x i8> @wrong_width_low_index_shorter_length_poison_basevec(i65 %x) {
; ALL-LABEL: @wrong_width_low_index_shorter_length_poison_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i65 [[X:%.*]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 0
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %t = trunc i65 %x to i8
  %r = insertelement <4 x i8> poison, i8 %t, i64 0
  ret <4 x i8> %r
}

define <4 x i8> @low_index_shorter_length_poison_basevec_extra_use(i64 %x) {
; ALL-LABEL: @low_index_shorter_length_poison_basevec_extra_use(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i8
; ALL-NEXT:    call void @use(i8 [[T]])
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 0
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %t = trunc i64 %x to i8
  call void @use(i8 %t)
  %r = insertelement <4 x i8> poison, i8 %t, i64 0
  ret <4 x i8> %r
}

define <4 x i16> @lshr_same_length_poison_basevec_le(i64 %x) {
; ALL-LABEL: @lshr_same_length_poison_basevec_le(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 32
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 2
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 32
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 2
  ret <4 x i16> %r
}

define <4 x i16> @lshr_same_length_poison_basevec_be(i64 %x) {
; ALL-LABEL: @lshr_same_length_poison_basevec_be(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 32
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 1
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 32
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 1
  ret <4 x i16> %r
}

define <4 x i16> @lshr_same_length_poison_basevec_both_endian(i64 %x) {
; ALL-LABEL: @lshr_same_length_poison_basevec_both_endian(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc nuw i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 0
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 0
  ret <4 x i16> %r
}

define <4 x i16> @lshr_wrong_index_same_length_poison_basevec(i64 %x) {
; ALL-LABEL: @lshr_wrong_index_same_length_poison_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc nuw i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> poison, i16 [[T]], i64 1
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> poison, i16 %t, i64 1
  ret <4 x i16> %r
}

define <8 x i16> @lshr_longer_length_poison_basevec_le(i64 %x) {
; ALL-LABEL: @lshr_longer_length_poison_basevec_le(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc nuw i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> poison, i16 [[T]], i64 3
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i16
  %r = insertelement <8 x i16> poison, i16 %t, i64 3
  ret <8 x i16> %r
}

define <8 x i16> @lshr_longer_length_poison_basevec_be(i64 %x) {
; ALL-LABEL: @lshr_longer_length_poison_basevec_be(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 32
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> poison, i16 [[T]], i64 1
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %s = lshr i64 %x, 32
  %t = trunc i64 %s to i16
  %r = insertelement <8 x i16> poison, i16 %t, i64 1
  ret <8 x i16> %r
}

define <8 x i16> @lshr_wrong_index_longer_length_poison_basevec(i64 %x) {
; ALL-LABEL: @lshr_wrong_index_longer_length_poison_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 16
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> poison, i16 [[T]], i64 6
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %s = lshr i64 %x, 16
  %t = trunc i64 %s to i16
  %r = insertelement <8 x i16> poison, i16 %t, i64 6
  ret <8 x i16> %r
}

define <2 x i16> @lshr_shorter_length_poison_basevec_le(i64 %x) {
; ALL-LABEL: @lshr_shorter_length_poison_basevec_le(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 16
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <2 x i16> poison, i16 [[T]], i64 1
; ALL-NEXT:    ret <2 x i16> [[R]]
;
  %s = lshr i64 %x, 16
  %t = trunc i64 %s to i16
  %r = insertelement <2 x i16> poison, i16 %t, i64 1
  ret <2 x i16> %r
}

define <4 x i8> @lshr_shorter_length_poison_basevec_be(i64 %x) {
; ALL-LABEL: @lshr_shorter_length_poison_basevec_be(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 40
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 2
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %s = lshr i64 %x, 40
  %t = trunc i64 %s to i8
  %r = insertelement <4 x i8> poison, i8 %t, i64 2
  ret <4 x i8> %r
}

define <4 x i8> @lshr_wrong_index_shorter_length_poison_basevec(i64 %x) {
; ALL-LABEL: @lshr_wrong_index_shorter_length_poison_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 40
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 3
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %s = lshr i64 %x, 40
  %t = trunc i64 %s to i8
  %r = insertelement <4 x i8> poison, i8 %t, i64 3
  ret <4 x i8> %r
}

define <4 x i8> @lshr_wrong_shift_shorter_length_poison_basevec(i64 %x) {
; ALL-LABEL: @lshr_wrong_shift_shorter_length_poison_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 57
; ALL-NEXT:    [[T:%.*]] = trunc nuw nsw i64 [[S]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 0
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %s = lshr i64 %x, 57
  %t = trunc i64 %s to i8
  %r = insertelement <4 x i8> poison, i8 %t, i64 0
  ret <4 x i8> %r
}

define <4 x i8> @lshr_shorter_length_poison_basevec_be_extra_use(i64 %x) {
; ALL-LABEL: @lshr_shorter_length_poison_basevec_be_extra_use(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 40
; ALL-NEXT:    call void @use64(i64 [[S]])
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> poison, i8 [[T]], i64 2
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %s = lshr i64 %x, 40
  call void @use64(i64 %s)
  %t = trunc i64 %s to i8
  %r = insertelement <4 x i8> poison, i8 %t, i64 2
  ret <4 x i8> %r
}

define <4 x i16> @low_index_same_length_basevec(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @low_index_same_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 0
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 0
  ret <4 x i16> %r
}

define <4 x i16> @high_index_same_length_basevec(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @high_index_same_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 3
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 3
  ret <4 x i16> %r
}

define <4 x i16> @wrong_index_same_length_basevec(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @wrong_index_same_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 1
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 1
  ret <4 x i16> %r
}

define <8 x i16> @low_index_longer_length_basevec(i64 %x, <8 x i16> %v) {
; ALL-LABEL: @low_index_longer_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> [[V:%.*]], i16 [[T]], i64 0
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <8 x i16> %v, i16 %t, i64 0
  ret <8 x i16> %r
}

define <8 x i16> @high_index_longer_length_basevec(i64 %x, <8 x i16> %v) {
; ALL-LABEL: @high_index_longer_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> [[V:%.*]], i16 [[T]], i64 3
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <8 x i16> %v, i16 %t, i64 3
  ret <8 x i16> %r
}

define <8 x i16> @wrong_index_longer_length_basevec(i64 %x, <8 x i16> %v) {
; ALL-LABEL: @wrong_index_longer_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> [[V:%.*]], i16 [[T]], i64 7
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <8 x i16> %v, i16 %t, i64 7
  ret <8 x i16> %r
}

define <2 x i16> @low_index_shorter_length_basevec(i64 %x, <2 x i16> %v) {
; ALL-LABEL: @low_index_shorter_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <2 x i16> [[V:%.*]], i16 [[T]], i64 0
; ALL-NEXT:    ret <2 x i16> [[R]]
;
  %t = trunc i64 %x to i16
  %r = insertelement <2 x i16> %v, i16 %t, i64 0
  ret <2 x i16> %r
}

define <4 x i8> @wrong_index_shorter_length_basevec(i64 %x, <4 x i8> %v) {
; ALL-LABEL: @wrong_index_shorter_length_basevec(
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[X:%.*]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> [[V:%.*]], i8 [[T]], i64 3
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %t = trunc i64 %x to i8
  %r = insertelement <4 x i8> %v, i8 %t, i64 3
  ret <4 x i8> %r
}

define <4 x i16> @lshr_same_length_basevec_le(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @lshr_same_length_basevec_le(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 32
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 2
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 32
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 2
  ret <4 x i16> %r
}

define <4 x i16> @lshr_same_length_basevec_be(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @lshr_same_length_basevec_be(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 32
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 1
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 32
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 1
  ret <4 x i16> %r
}

define <4 x i16> @lshr_same_length_basevec_both_endian(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @lshr_same_length_basevec_both_endian(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc nuw i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 3
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 3
  ret <4 x i16> %r
}

define <4 x i16> @lshr_wrong_index_same_length_basevec(i64 %x, <4 x i16> %v) {
; ALL-LABEL: @lshr_wrong_index_same_length_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc nuw i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i16> [[V:%.*]], i16 [[T]], i64 1
; ALL-NEXT:    ret <4 x i16> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i16
  %r = insertelement <4 x i16> %v, i16 %t, i64 1
  ret <4 x i16> %r
}

define <8 x i16> @lshr_longer_length_basevec_le(i64 %x, <8 x i16> %v) {
; ALL-LABEL: @lshr_longer_length_basevec_le(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc nuw i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> [[V:%.*]], i16 [[T]], i64 3
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i16
  %r = insertelement <8 x i16> %v, i16 %t, i64 3
  ret <8 x i16> %r
}

define <8 x i16> @lshr_longer_length_basevec_be(i64 %x, <8 x i16> %v) {
; ALL-LABEL: @lshr_longer_length_basevec_be(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 32
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> [[V:%.*]], i16 [[T]], i64 1
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %s = lshr i64 %x, 32
  %t = trunc i64 %s to i16
  %r = insertelement <8 x i16> %v, i16 %t, i64 1
  ret <8 x i16> %r
}

define <8 x i16> @lshr_wrong_index_longer_length_basevec(i64 %x, <8 x i16> %v) {
; ALL-LABEL: @lshr_wrong_index_longer_length_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 16
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <8 x i16> [[V:%.*]], i16 [[T]], i64 6
; ALL-NEXT:    ret <8 x i16> [[R]]
;
  %s = lshr i64 %x, 16
  %t = trunc i64 %s to i16
  %r = insertelement <8 x i16> %v, i16 %t, i64 6
  ret <8 x i16> %r
}

define <2 x i16> @lshr_shorter_length_basevec_le(i64 %x, <2 x i16> %v) {
; ALL-LABEL: @lshr_shorter_length_basevec_le(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 16
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i16
; ALL-NEXT:    [[R:%.*]] = insertelement <2 x i16> [[V:%.*]], i16 [[T]], i64 1
; ALL-NEXT:    ret <2 x i16> [[R]]
;
  %s = lshr i64 %x, 16
  %t = trunc i64 %s to i16
  %r = insertelement <2 x i16> %v, i16 %t, i64 1
  ret <2 x i16> %r
}

define <4 x i8> @lshr_shorter_length_basevec_be(i64 %x, <4 x i8> %v) {
; ALL-LABEL: @lshr_shorter_length_basevec_be(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 48
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> [[V:%.*]], i8 [[T]], i64 1
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %s = lshr i64 %x, 48
  %t = trunc i64 %s to i8
  %r = insertelement <4 x i8> %v, i8 %t, i64 1
  ret <4 x i8> %r
}

define <4 x i8> @lshr_wrong_index_shorter_length_basevec(i64 %x, <4 x i8> %v) {
; ALL-LABEL: @lshr_wrong_index_shorter_length_basevec(
; ALL-NEXT:    [[S:%.*]] = lshr i64 [[X:%.*]], 40
; ALL-NEXT:    [[T:%.*]] = trunc i64 [[S]] to i8
; ALL-NEXT:    [[R:%.*]] = insertelement <4 x i8> [[V:%.*]], i8 [[T]], i64 3
; ALL-NEXT:    ret <4 x i8> [[R]]
;
  %s = lshr i64 %x, 40
  %t = trunc i64 %s to i8
  %r = insertelement <4 x i8> %v, i8 %t, i64 3
  ret <4 x i8> %r
}
