; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=zEC12 -verify-machineinstrs \
; RUN:   | FileCheck %s --check-prefix=NOVEC
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z16 -verify-machineinstrs \
; RUN:   | FileCheck %s  --check-prefix=VECTOR
;
; Test moves (bitcasts) between i16 and half.

define half @f1(ptr %ptr) {
; NOVEC-LABEL: f1:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    lh %r0, 0(%r2)
; NOVEC-NEXT:    oill %r0, 255
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    # kill: def $f0h killed $f0h killed $f0d
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: f1:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    lh %r0, 0(%r2)
; VECTOR-NEXT:    oill %r0, 255
; VECTOR-NEXT:    vlvgh %v0, %r0, 0
; VECTOR-NEXT:    br %r14
  %L = load i16, ptr %ptr
  %O = or i16 %L, 255
  %res = bitcast i16 %O to half
  ret half %res
}

define half @f2(i16 %Arg) {
; NOVEC-LABEL: f2:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    # kill: def $r2l killed $r2l def $r2d
; NOVEC-NEXT:    sllg %r0, %r2, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    # kill: def $f0h killed $f0h killed $f0d
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: f2:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    vlvgh %v0, %r2, 0
; VECTOR-NEXT:    br %r14
  %res = bitcast i16 %Arg to half
  ret half %res
}

define void @f3(half %val, ptr %ptr) {
; NOVEC-LABEL: f3:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    # kill: def $f0h killed $f0h def $f0d
; NOVEC-NEXT:    lgdr %r0, %f0
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    stc %r0, 0(%r2)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: f3:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    vlgvh %r0, %v0, 0
; VECTOR-NEXT:    stc %r0, 0(%r2)
; VECTOR-NEXT:    br %r14
  %res = bitcast half %val to i16
  %trunc = trunc i16 %res to i8
  store i8 %trunc, ptr %ptr
  ret void
}

define i16 @f4(half %Arg) {
; NOVEC-LABEL: f4:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    # kill: def $f0h killed $f0h def $f0d
; NOVEC-NEXT:    lgdr %r0, %f0
; NOVEC-NEXT:    srlg %r2, %r0, 48
; NOVEC-NEXT:    # kill: def $r2l killed $r2l killed $r2d
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: f4:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    vlgvh %r2, %v0, 0
; VECTOR-NEXT:    br %r14
  %res = bitcast half %Arg to i16
  ret i16 %res
}
