; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -global-isel=0                    -mtriple=x86_64-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=X64,SDAG
; RUN: llc < %s -fast-isel -fast-isel-abort=1     -mtriple=x86_64-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=X64,FASTISEL
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X64
; RUN: llc < %s -global-isel=0                    -mtriple=i686-apple-darwin10   -verify-machineinstrs | FileCheck %s --check-prefixes=X86,SDAG,SDAG-X86
; RUN: llc < %s -fast-isel -fast-isel-abort=1     -mtriple=i686-apple-darwin10   -verify-machineinstrs | FileCheck %s --check-prefixes=X86,FASTISEL,FASTISEL-X86
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-apple-darwin10   -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X86

define i32 @icmp_eq_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_eq_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jne LBB0_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB0_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_eq_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB0_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB0_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_eq_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jne LBB0_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB0_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_eq_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jne LBB0_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB0_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_eq_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB0_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB0_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp eq i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ne_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_ne_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    je LBB1_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB1_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_ne_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB1_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB1_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_ne_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    je LBB1_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB1_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_ne_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    je LBB1_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB1_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_ne_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setne %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB1_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB1_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ne i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ugt_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_ugt_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jbe LBB2_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB2_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_ugt_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB2_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB2_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_ugt_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jbe LBB2_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB2_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_ugt_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jbe LBB2_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB2_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_ugt_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB2_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB2_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ugt i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_uge_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_uge_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jb LBB3_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB3_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_uge_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB3_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB3_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_uge_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jb LBB3_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB3_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_uge_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jb LBB3_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB3_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_uge_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB3_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB3_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp uge i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ult_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_ult_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jae LBB4_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB4_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_ult_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB4_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB4_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_ult_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jae LBB4_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB4_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_ult_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jae LBB4_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB4_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_ult_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB4_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB4_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ult i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ule_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_ule_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    ja LBB5_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB5_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_ule_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB5_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB5_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_ule_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    ja LBB5_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB5_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_ule_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    ja LBB5_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB5_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_ule_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB5_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB5_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ule i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_sgt_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_sgt_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jle LBB6_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB6_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_sgt_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setg %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB6_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB6_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_sgt_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jle LBB6_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB6_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_sgt_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jle LBB6_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB6_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_sgt_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setg %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB6_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB6_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp sgt i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_sge_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_sge_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jl LBB7_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB7_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_sge_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setge %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB7_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB7_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_sge_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jl LBB7_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB7_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_sge_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jl LBB7_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB7_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_sge_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setge %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB7_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB7_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp sge i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_slt_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_slt_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jge LBB8_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB8_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_slt_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setl %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB8_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB8_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_slt_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jge LBB8_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB8_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_slt_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jge LBB8_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB8_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_slt_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setl %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB8_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB8_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp slt i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_sle_2(i32 %x, i32 %y) {
; X64-LABEL: icmp_sle_2:
; X64:       ## %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jg LBB9_1
; X64-NEXT:  ## %bb.2: ## %bb1
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
; X64-NEXT:  LBB9_1: ## %bb2
; X64-NEXT:    movl $1, %eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: icmp_sle_2:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %esi, %edi
; GISEL-X64-NEXT:    setle %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB9_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB9_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: icmp_sle_2:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    jg LBB9_1
; SDAG-X86-NEXT:  ## %bb.2: ## %bb1
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    retl
; SDAG-X86-NEXT:  LBB9_1: ## %bb2
; SDAG-X86-NEXT:    movl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: icmp_sle_2:
; FASTISEL-X86:       ## %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; FASTISEL-X86-NEXT:    jg LBB9_1
; FASTISEL-X86-NEXT:  ## %bb.2: ## %bb1
; FASTISEL-X86-NEXT:    xorl %eax, %eax
; FASTISEL-X86-NEXT:    retl
; FASTISEL-X86-NEXT:  LBB9_1: ## %bb2
; FASTISEL-X86-NEXT:    movl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: icmp_sle_2:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    setle %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB9_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB9_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp sle i32 %x, %y
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_eq(i32 %x) {
; SDAG-LABEL: icmp_eq:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB10_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB10_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_eq:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    xorl %eax, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_eq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB10_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB10_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_eq:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB10_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB10_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp eq i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ne(i32 %x) {
; SDAG-LABEL: icmp_ne:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB11_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB11_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_ne:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    movl $1, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_ne:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB11_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB11_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_ne:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setne %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB11_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB11_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ne i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ugt(i32 %x) {
; SDAG-LABEL: icmp_ugt:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB12_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB12_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_ugt:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    movl $1, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_ugt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB12_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB12_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_ugt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB12_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB12_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ugt i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_uge(i32 %x) {
; SDAG-LABEL: icmp_uge:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB13_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB13_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_uge:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    xorl %eax, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_uge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB13_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB13_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_uge:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB13_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB13_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp uge i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ult(i32 %x) {
; SDAG-LABEL: icmp_ult:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB14_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB14_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_ult:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    movl $1, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_ult:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB14_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB14_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_ult:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB14_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB14_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ult i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_ule(i32 %x) {
; SDAG-LABEL: icmp_ule:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB15_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB15_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_ule:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    xorl %eax, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_ule:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB15_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB15_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_ule:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB15_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB15_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp ule i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_sgt(i32 %x) {
; SDAG-LABEL: icmp_sgt:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB16_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB16_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_sgt:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    movl $1, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_sgt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setg %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB16_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB16_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_sgt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setg %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB16_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB16_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp sgt i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_sge(i32 %x) {
; SDAG-LABEL: icmp_sge:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB17_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB17_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_sge:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    xorl %eax, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_sge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setge %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB17_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB17_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_sge:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setge %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB17_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB17_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp sge i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_slt(i32 %x) {
; SDAG-LABEL: icmp_slt:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB18_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB18_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_slt:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    movl $1, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_slt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setl %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB18_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB18_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_slt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setl %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB18_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB18_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp slt i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}

define i32 @icmp_sle(i32 %x) {
; SDAG-LABEL: icmp_sle:
; SDAG:       ## %bb.0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    testb %al, %al
; SDAG-NEXT:    je LBB19_1
; SDAG-NEXT:  ## %bb.2: ## %bb1
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    ret{{[l|q]}}
; SDAG-NEXT:  LBB19_1: ## %bb2
; SDAG-NEXT:    movl $1, %eax
; SDAG-NEXT:    ret{{[l|q]}}
;
; FASTISEL-LABEL: icmp_sle:
; FASTISEL:       ## %bb.0:
; FASTISEL-NEXT:    xorl %eax, %eax
; FASTISEL-NEXT:    ret{{[l|q]}}
;
; GISEL-X64-LABEL: icmp_sle:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    cmpl %edi, %edi
; GISEL-X64-NEXT:    setle %al
; GISEL-X64-NEXT:    testb $1, %al
; GISEL-X64-NEXT:    je LBB19_1
; GISEL-X64-NEXT:  ## %bb.2: ## %bb1
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    retq
; GISEL-X64-NEXT:  LBB19_1: ## %bb2
; GISEL-X64-NEXT:    movl $1, %eax
; GISEL-X64-NEXT:    retq
;
; GISEL-X86-LABEL: icmp_sle:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    cmpl %eax, %eax
; GISEL-X86-NEXT:    setle %al
; GISEL-X86-NEXT:    testb $1, %al
; GISEL-X86-NEXT:    je LBB19_1
; GISEL-X86-NEXT:  ## %bb.2: ## %bb1
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    retl
; GISEL-X86-NEXT:  LBB19_1: ## %bb2
; GISEL-X86-NEXT:    movl $1, %eax
; GISEL-X86-NEXT:    retl
  %1 = icmp sle i32 %x, %x
  br i1 %1, label %bb1, label %bb2
bb2:
  ret i32 1
bb1:
  ret i32 0
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; X86: {{.*}}
